<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:cif="cif">
    <xsl:param name="xslShowHelp" select="cif:xslShowHelp"/>
    <xsl:param name="xslRootDirectory" select="cif:xslRootDirectory"/>

    <xsl:output method="text" media-type="text/plain" encoding="iso-8859-1"/>
    <xsl:template match="/">
        <xsl:variable name="gridOut" select="cif:SetGridOut(number(InRoads/@outputGridScaleFactor))"/>
        <xsl:choose>
            <xsl:when test="$xslShowHelp = 'true'">
                <xsl:call-template name="StyleSheetHelp"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:for-each select="InRoads">
                    <xsl:text/>
                    <xsl:text>* Výpis staničení a výšky v profilu (z výškového řešení)&#xd;</xsl:text>
                    <xsl:text>*         Datum výpisu: </xsl:text><xsl:value-of select="cif:date()"/><xsl:text>&#xd;</xsl:text>

                    <xsl:for-each select="GeometryProject">
                        <xsl:text>*              Projekt: </xsl:text><xsl:value-of select="@name"/><xsl:text>&#xd;</xsl:text>
                        <xsl:text>*        Název souboru: </xsl:text><xsl:value-of select="@file"/><xsl:text>&#xd;</xsl:text>

                        <xsl:for-each select="HorizontalAlignment[HorizontalEventPoints]">
                            <xsl:text>*       Směrové řešení: </xsl:text><xsl:value-of select="@name"/><xsl:text>&#xd;</xsl:text>
                            <xsl:for-each select="VerticalAlignment">
                                <xsl:text>*       Výškové řešení: </xsl:text><xsl:value-of select="@name"/><xsl:text>&#xd;</xsl:text>
                                <xsl:text>*&#xd;</xsl:text>
                            </xsl:for-each>
                            <xsl:text>*    Staničení        Výška&#xd;</xsl:text>
                            <xsl:text>*&#xd;</xsl:text>
                            <xsl:for-each select="HorizontalEventPoints/*/HorizontalEventPoint">
                                <xsl:variable name="fmtStation" select="cif:stationFormat(number(GeometryPoint/station/@externalStation), string(GeometryPoint/station/@externalStationName))"/>
                                <xsl:value-of select="cif:columnFormat(string($fmtStation), 12)"/>
                                <xsl:value-of select="cif:columnDoubleFormat(number(GeometryPoint/@elevation), 17)"/>
                                <xsl:text>&#xd;</xsl:text>
                            </xsl:for-each>
                            <xsl:text>&#xd;</xsl:text>
                        </xsl:for-each>
                    </xsl:for-each>
                </xsl:for-each>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template name="StyleSheetHelp">
        <xsl:text>Poznámky&#xd;&#xd;</xsl:text>
        <xsl:text>Pro tento výpis musíte vybrat nejméně</xsl:text>
        <xsl:text>jeden prvek výškové geometrie.   &#xd;&#xd;</xsl:text>
        <xsl:text>Copyright 2012 Bentley Systems, Inc&#xd;</xsl:text>
    </xsl:template>
</xsl:stylesheet>
